<?php
require("../includes/header.php");

// appname
require_once("../config/connection.php");
$query = "SELECT appname FROM app_settings";

$result = $mysqli->query($query);
$row = $result->fetch_assoc();
$appname = $row['appname'];

//add Menu
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Verify CSRF token
    if (!csrf_verify($_POST['csrf_token'] ?? null)) {
        http_response_code(403);
        die('Invalid CSRF token');
    }

    // Sanitize and validate inputs
    $menuName = get_str('menu_name');
    $menuIcon = get_str('menu_icon');
    $menuType = get_str('menu_type');
    $menuData = get_str('menu_data');
    $toolbarColor = get_str('toolbar_color', '#000000');
    $enabled = get_bool('is_enabled') ? 1 : 0;

    // Validate required fields
    if (empty($menuName) || empty($menuType) || empty($menuData)) {
        header('Location: add_menu.php?error=missing_fields');
        exit();
    }

    // Validate menu type
    $allowed_types = ['webview', 'wordpress', 'intent', 'custom', 'rss', 'ytrss'];
    if (!in_array($menuType, $allowed_types)) {
        header('Location: add_menu.php?error=invalid_type');
        exit();
    }

    // Insert the new menu item into the database
    $query = "INSERT INTO app_menu (menu_name, menu_icon, menu_type, menu_data, is_enabled, order_id, toolbar_color) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);

    if (!$stmt) {
        error_log("MySQL prepare error: " . $mysqli->error);
        header('Location: add_menu.php?error=database_error');
        exit();
    }

    $orderId = null; // Set the initial value of order_id to null

    $stmt->bind_param("ssssiis", $menuName, $menuIcon, $menuType, $menuData, $enabled, $orderId, $toolbarColor);

    if ($stmt->execute()) {
        // Success! Get the last inserted ID
        $lastInsertId = $stmt->insert_id;

        // Update the "order_id" to have the same value as "id"
        $updateQuery = "UPDATE app_menu SET order_id = ? WHERE id = ?";
        $updateStmt = $mysqli->prepare($updateQuery);

        if (!$updateStmt) {
            error_log("MySQL prepare error: " . $mysqli->error);
            $stmt->close();
            header('Location: add_menu.php?error=database_error');
            exit();
        }

        $updateStmt->bind_param("ii", $lastInsertId, $lastInsertId);

        if ($updateStmt->execute()) {
            $updateStmt->close();
            $stmt->close();
            header("Location: list_pages.php?success=1");
            exit();
        } else {
            error_log("Error updating order_id: " . $updateStmt->error);
            $updateStmt->close();
            $stmt->close();
            header('Location: add_menu.php?error=update_failed');
            exit();
        }
    } else {
        error_log("Error inserting menu: " . $stmt->error);
        $stmt->close();
        header('Location: add_menu.php?error=insert_failed');
        exit();
    }
}
?>
<title>Add Menu</title>

<meta name="description" content="" />

</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php require("../includes/sidebar.php") ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php require("../includes/navbar.php") ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">App /</span> Menu Items</h4>
                        <!-- Contextual Classes -->
                        <ul class="nav nav-pills flex-column flex-md-row mb-3">
                            <li class="nav-item">
                                <a class="nav-link " href="list_pages.php"><i class="bx bx-user me-1"></i> View Menu</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link active" href="add_menu.php"><i class="bx bx-bell me-1"></i> Add Menu</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="menu_sort.php"><i class="bx bx-link-alt me-1"></i> Rearrange Menu</a>
                            </li>
                        </ul>
                    <!-- Content -->
                    <div class="form-container">
        
<hr/>
<div class="mt-2 mb-3">
        <form method="POST" action="add_menu.php">
            <?= csrf_input(); ?>
            
            <div class="form-group">
              
                <input type="text" id="order_id" class="form-control" name="order_id" value="<?php echo $orderId; ?>" hidden />
            </div>

            <div class="form-group">
                <label for="menuName">Menu Name</label>
                <input type="text" id="menu_name" class="form-control" name="menu_name" value="" required/>
            </div>
<br/>
            <div class="form-group">
                <label for="menuIcon">Menu Icon</label>
                
                   
<textarea class="form-control" name="menu_icon" id="menu_icon" rows="3"></textarea>
              
            </div>
<br/>
            <div class="form-group">
                <label for="menuType">Menu Type</label>
                <select class="form-control" id="menu_type" name="menu_type" required>
                    <option value="" selected>Select Type</option>
                    <option value="webview">Webview</option>
                     <option value="wordpress">Wordpress</option>
                    <option value="intent">Intent</option>
                     <option value="rss">RSS Feed</option>
                     <option value="ytrss">Youtube RSS</option>
                    
                    
                    
                </select>
            </div>
<br/>
            <div class="form-group">
                <label for="menuData">Menu Data</label>
                <input type="text" class="form-control" id="menu_data" name="menu_data" value="" required/>
            </div>
<br/>
<div class="form-group" id="toolbar-color-group">
    <label for="toolbarColor">Toolbar Color</label><br>
    
    
    
    
      <input type="text" id="toolbar_color" name="toolbar_color" value="#000000"
                                            
    style="color: #697a8d;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #d9dee3;
    appearance: none;
    border-radius: 0.375rem;
    transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
    display: block;
    width: 100%;
    padding: 0.4375rem 0.875rem;
    font-size: .9375rem;
    font-weight: 400;
    line-height: 1.53;"
    value="<?php echo $toolbar_color ?>" data-coloris>
    
                                            <br>
</div>
<br/>
            <div class="form-group">
                <div class="form-check">
                    <input class="form-check-input" name="is_enabled" type="checkbox" value="" id="is_enabled">
                    <label class="form-check-label" for="is_enabled">Enabled</label>
                </div>
            </div>
<br/>
            <div class="form-group">
                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
            <br/>
        </form>
         </div>
        
    </div>
    <!-- / Content -->
     <br/><br/>
     </div>
    
</body>
<link rel="stylesheet" href="../assets/coloris.min.css"/>
<script src="../assets/coloris.min.js"></script>
    <script type="text/javascript">
        Coloris({
            alpha: false,
            margin: 5,
            format: 'hex',
            theme: 'default',
            focusInput: true,
            el: '.coloris',
            swatches:       [
                '#cceaff',
                '#ffcccc',
                '#feffcc',
                '#ffccf1',
                '#d1ffcc',
                '#cceaff',
                '#cdccff',
                '#daccff',
                '#efccff',
                '#fff1cc',
                '#b1adff',
                            ] });
    </script>
    
 <script>
    document.addEventListener("DOMContentLoaded", function () {
        const menuTypeSelect = document.getElementById("menu_type");
        const toolbarColorGroup = document.getElementById("toolbar-color-group");
        const form = document.querySelector("form");
        const menuDataInput = document.getElementById("menu_data");

        // Function to toggle Toolbar Color visibility
        function toggleToolbarColor() {
            if (menuTypeSelect.value === "webview") {
                toolbarColorGroup.style.display = "block"; // Show
            } else {
                toolbarColorGroup.style.display = "none"; // Hide
            }
        }

        // Function to validate WordPress URL
        function validateWordPressURL(event) {
            if (menuTypeSelect.value === "wordpress") {
                const menuData = menuDataInput.value.trim();
                if (!menuData.endsWith("/")) {
                    event.preventDefault(); // Prevent form submission
                    alert("For WordPress menu type, the URL must end with a '/'.");
                }
            }
        }

        // Run the toggle function on page load (for default value)
        toggleToolbarColor();

        // Add event listener for changes to the Menu Type dropdown
        menuTypeSelect.addEventListener("change", toggleToolbarColor);

        // Add form submit event listener to validate WordPress URL
        form.addEventListener("submit", validateWordPressURL);
    });
</script>




<script>
function goBack() {
            // Navigate to pages.php
            window.location = "./list_pages.php";
        }
        </script>
        
        
<?php require("../includes/footer.php"); ?>
</html>
